#ifndef IGEOMETRYCONTAINER_H
#define IGEOMETRYCONTAINER_H

#include <buildspec.h>

#include <Geometry/IFileSerialisable.h>
#include <boost/ptr_container/ptr_list.hpp>
#include <string>

namespace GST
{
namespace Geometry
{
class IGeometry;
}
namespace Parsers
{

using namespace Geometry;

/**
	The GeometryContainer (interface). This defines the interface of container
   class for geometries. This includes getGeometries and saveToFile.
*/
class GST_API_EXPORT IGeometryContainer
{
public:
	/*IGeometryContainer()
	{}*/
	virtual ~IGeometryContainer()
	{
	}

	typedef boost::ptr_list<IGeometry> GeometryContainer;
	virtual GeometryContainer *getGeometries() = 0;
	virtual void clearGeometries() = 0;

}; // of class

} // namespace Parsers
} // namespace GST

#endif // IGEOMETRYCONTAINER_H
